from datetime import date, datetime
import subprocess
import re, os, sys
import time, socket
import pickle
import json
import argparse
import requests

# new packages
import win32gui, win32process, win32api, win32con, pywintypes


def currdate():#getting current date only
    return str(date.today())

def enumWindowsProc(hwnd, param):
    if win32gui.IsWindowVisible(hwnd) and win32gui.GetWindowTextLength(hwnd) > 0:
        window_counter[0] += 1
        if window_counter[0] == 2:
           window_counter[0] = hwnd
           return False
    return True


def getFileDescription(windows_exe):
    try:
        language, codepage = win32api.GetFileVersionInfo(windows_exe, '\\VarFileInfo\\Translation')[0]
        stringFileInfo = u'\\StringFileInfo\\%04X%04X\\%s' % (language, codepage, "FileDescription")
        description = win32api.GetFileVersionInfo(windows_exe, stringFileInfo)
    except:
        description = "unknown"
        
    return description
    

def currwin():
    try:
        win32gui.EnumWindows(enumWindowsProc,window_counter)
    except:
        pass
    
    hwnd = window_counter[0]
    count = 3
    while count:
        pid = win32process.GetWindowThreadProcessId(hwnd)
        try:
            handle = win32api.OpenProcess(win32con.PROCESS_QUERY_INFORMATION | win32con.PROCESS_VM_READ, False, pid[1])
            break
        except pywintypes.error:
            count -= 1
            time.sleep(3)
            continue
        
    proc_name = getFileDescription(win32process.GetModuleFileNameEx(handle, 0))
    fr_name = win32gui.GetWindowText(hwnd)
    dt = datetime.now()
 
    with open(r"C:\Database\data\data.txt", "a", encoding="utf-8") as fp:
        fp.write(f'{dt},{proc_name}, {win32gui.GetWindowText(hwnd)}\n')

    return (proc_name, fr_name)

window_counter = [0]


# get SN from cmd prompt
def getSerialNumber(snum):
    cmd = 'wmic bios get serialnumber'
    snum = subprocess.check_output(cmd.split(), creationflags=subprocess.CREATE_NO_WINDOW).decode('utf-8')
    snum = snum.split('\n')[1].strip()
    print(f'Service Tag: {snum}')
    return snum


#collect the scool DISE ID manually while installing
def getSchoolDise(opts):
    with open(opts.gpid,"r", encoding='utf-8') as fp:
        lines = fp.readlines()
        print(f'GP ID: { lines[0].strip()}\n')
    return lines[0].strip()
 
def loadPicdb(opts, pname, frname):
    ''' 
    Load the pickle db if it exists, else create a new one
    and initialize it and return the dictionary.
    '''
    
    if not os.path.isfile(opts.pikldb):
        curr_date=currdate()
        time=datetime.now()
        timenow = time.strftime('%H:%M:%S')
        date=datetime.now()
        wininfo = {'upload': {'status': False, 'date': date}, 'payload': {}}
        wininfo['payload'][frname]={
            'macid': opts.serialnumber,
            'gpid' : opts.schooldise,
            'windate':currdate(),
            'wintime':timenow,
            'procname':pname,
            'winname':frname,
            'ttime':0}
    else:
        with open(opts.pikldb,"rb") as ofile:
            wininfo=pickle.load(ofile)
    for i,(k,v) in enumerate(wininfo['payload'].items()):
        print(f'{i}:{k}:, {v}')
    return wininfo
    


def savePicDb(pikldb,data):
    print("saving db")
    with open(pikldb,"wb") as ofile:
        pickle.dump(data,ofile)

def getDataFromFile(f):
    with open(f,"r") as fp:
        lines = fp.readlines()
    print(lines[0].strip())
    return lines[0].strip()

def checkProjectorStatus():
    # returning false here (need to remove or integrate it for windows)
    return False
    hdmicards = []
    for r,d,files in os.walk('/sys/class/drm'):
        hdmicards.extend([x for x in d if 'HDMI' in x])
    for card in hdmicards:
        fname = '{}/{}/status'.format(r,card)
        if getDataFromFile(fname) == 'connected':
            return True
    return False
        
def updateData(wininfo, opts, pname, frname):
    '''
    Update the dictionary wininfo. If the tab already exists update the time,
    else create a new entry in the dictionary and return it.
    '''
    print(f'\n update: {wininfo}')
    curr_date=currdate()
    timenow=datetime.now().strftime('%H:%M:%S')
    #pname,frname=currwin()
    if pname == '' and  frname == '':
        pname = 'Standby'
        frname = 'Standby'
    elif frname and pname == '':
        pname = 'Monitor off'
    elif pname and frname == '':
        frname = 'Windown minimized'

    to_write='{},{},{},{},{}'.format(curr_date,timenow,pname,frname,opts.interval)

    if frname in wininfo['payload'].keys():
        wininfo['payload'][frname]['ttime']+=opts.interval
        #print(wininfo)
    else:
        wininfo['payload'][frname]={
            'macid': opts.serialnumber,
            'gpid' : opts.schooldise,
            'windate':curr_date,
            'wintime':timenow,
            'procname':pname,
            'winname':frname,
            'ttime':0}

    # update projector status
    if 'projector' in wininfo['payload'].keys() and checkProjectorStatus():
        wininfo['payload']['projector']['ttime']+=opts.interval
    else:
        wininfo['payload']['projector']={
                'macid': opts.serialnumber,
                'gpid' : opts.schooldise,
                'windate':curr_date,
                'wintime':timenow,
                'procname':'projector',
                'winname':'projector',
                'ttime':0}
    return wininfo
            
def writetocsv(dirname,csvfile,pikldb):
    dirpath=os.path.join(dirname,csvfile)
    with open('{}/{}'.format(dirname,csvfile),"w") as csvfile:
        with open(pikldb,"rb") as pfile:
            xfile=pickle.load(pfile)
            for key,values in xfile.items():
                pass
                #csvline=(f"{key},{values['date']},{values['time']},"
                #     f"{values['pname']},{values['frname']},"
                #     f"{values['ttime']}\n")
                #print(csvline)
                #csvfile.write(csvline)

def uploadData(wdata,serverinfo):
    '''
    Upload data to sikshana server.
    '''
    print("Server:", serverinfo)
    wininfo = {'upload': {'status': True, 'date': date}, 'payload': {}}
    try:
        #response = requests.post(serverinfo['url'], data=wdata) # changed for gramadigivikasa.in - earlier we use to send with payload
        response = requests.post(serverinfo['url'], json=wdata, headers=serverinfo['headers'])
        print(f'response num: {response.status_code}')
        if response.status_code == 200:
            return True
        else:
            return False
    except requests.exceptions.ConnectTimeout:
        return False
  
        
def uploadStatus(wdata):
    print("WDATA:")
    print(wdata)
    return wdata['upload']
    
def tdelta(tobject, kind):
    if kind == 'days':
        return tobject.days
    elif kind == 'seconds':
        return tobject.seconds
    else:
        return round(tobject.seconds/60)
    
def main():
    pass
    
            
def checkNet():
    try:
        # connect to the host -- tells us if the host is actually
        # reachable
        with socket.create_connection(("www.google.com", 80)) as sock:
            if sock is not None:
                return True
    except OSError:
        pass
    return False


# ----------------  main ------------------ #
parser=argparse.ArgumentParser(description="Passing dirname & filename")
parser.add_argument('--dirname',help='pass the directory path to store file',required=False)
parser.add_argument('--fname',help='pass the file name you want in the dirpath',required=False)
parser.add_argument('--pikldb',help="pass the file path of the pickle db",required=False)
parser.add_argument('--interval',help="duration between each log",default=1,required=False)
parser.add_argument('--check',help="if net available, dump file to db",default=False)
parser.add_argument('--register', action=argparse.BooleanOptionalAction),
parser.add_argument('--serialn',help="File containing the serial number", default=r"C:\Database\data\.serialn")
parser.add_argument('--gpid', help="File containing the school dise number", default=r"C:\Database\data\.gpid")

#args=parser.parse_args()
#opts=r'--dirname C:/Database/data/ --fname test.csv --pikldb C:\Database\data\.mypickle'
#args=parser.parse_args(opts.split())
args=parser.parse_args()
args.serialnumber = getSerialNumber(args)
args.schooldise = getSchoolDise(args)
args.dirname = 'C:/Database/data/'
args.fname = 'test.csv'
args.pikldb = r'C:\Database\data\.mypickle'




window_counter =[0]
pname, fname = currwin()

# load the pickle db if it exists or update it with the current info
wininfo = loadPicdb(args, pname, fname)
uwininfo = updateData(wininfo, args, pname, fname)
for k,v in uwininfo['payload'].items():
    print(k,v)

# save the db any way
savePicDb(args.pikldb, uwininfo)

# convert the saved data to a list format to convert to json
dlist = []
for k,v in uwininfo['payload'].items():
    if v['ttime'] != 0:
            dlist.append(v)

# changed for gramadigivikasa.in - earlier we use to send with payload
#jsondata = dict(payload=json.dumps(dlist))
jsondata = dlist
payload=json.dumps(dlist)


serverinfo = {'url': 'https://apis.gramadigivikasana.in/trackers/ap/upload.php',
    'headers': {'Accept' : 'application/json',
    'Content-Type': 'application/json'}} 

args.check = True

# upload the data only if the data was uploaded more than 10 minutes ago
if uwininfo['upload']['status']:
    timedelta = datetime.now() - uwininfo['upload']['date']
    print(tdelta(timedelta,'mins'))
    print(uwininfo['upload'])
    if tdelta(timedelta, 'minutes') >= 60: 
        uwininfo['upload']['status'] = False


with open (r"C:\Database\data\log.txt", "a") as fp:
    fp.write(f'{datetime.now()} \n ---- scheduled run:\n')  

if args.check and not uwininfo['upload']['status']:
    with open (r"C:\Database\data\log.txt", "a") as fp:
        fp.write(f'{datetime.now()} begin \n')  
    if checkNet():
        if uploadData(jsondata, serverinfo):
            uwininfo['upload']['status'] = True
            uwininfo['upload']['date'] = datetime.now()
            uwininfo['payload'] = {}
            savePicDb(args.pikldb, uwininfo) 
            with open (r"C:\Database\data\log.txt", "a") as fp:
                fp.write(f'{datetime.now()} Upload success \n')  
        else:
            with open (r"C:\Database\data\log.txt", "a") as fp:
                fp.write(f'{datetime.now()} not uploaded \n')         
    else:
         with open (r"C:\Database\data\log.txt", "a") as fp:
            fp.write(f'{datetime.now()} url down \n')




print(f'First Time: {args.register}')
# Upload one time for installation confirmation after register.
if args.register:
    if uploadData(jsondata, serverinfo):
        uwininfo['upload']['status'] = True
        uwininfo['upload']['date'] = datetime.now()
        uwininfo['payload'] = {}
        savePicDb(args.pikldb, uwininfo) 
        with open (r"C:\Database\data\log.txt", "a") as fp:
            fp.write(f'{datetime.now()} Upload success \n')  
    else:
        with open (r"C:\Database\data\log.txt", "a") as fp:
            fp.write(f'{datetime.now()} not uploaded \n')
